# Vertragsklauseln

Bei der Erstellung von Dokumenten kann auf vorgegebene Vertragsklauseln zugegriffen werden. Dies ermöglicht es, Klauseln zu standardisieren und auf einheitlichem Wege in Vertragsdokumente zu übernehmen. Ebenso ist es möglich, Klauseln zentral zu bearbeiten und daraufhin in den jeweiligen Vertragsdokumenten zu aktualisieren, welche die Klauseln enthalten.

## Klauselvorlagen

Klauselvorlagen bieten die Möglichkeit, bereits bestimmten Grundarten von Klauseln vorzugeben. Eine Vorlage besteht bereits aus einer Word-Datei und kann bspw. die notwendige Formatierung und CI-konforme Designs und Layouts enthalten. Klauselvorlagen landen nicht direkt im Vertragsdokument, aus ihnen können lediglich neue Vertragsklauseln erstellt werden.

<span class="tag_warning">Klauselvorlagen müssen wie auch die Dokumentvorlagen Microsoft Word-Dokumente im Format `.doc` oder `.docx` sein, da sie sonst nicht in die erstellten Vertragsdokumente integriert werden können. Sie müssen zudem mit der Verschlagwortungsmaske <span
style='font-weight:bold;font-style:italic'>Vertragsklausel</span> (<span
style='font-style:italic'>Contract Clause</span>) abgelegt werden.</span>

### Klauselvorlagen über die Konfiguration ändern

Vorlagen können direkt über die Konfiguration des Vertragsmanagements unter <span
style='font-weight:bold;font-style:italic'>Klauselvorlagen</span> bearbeitet werden. Hierbei können neue Vorlagen hinzugefügt, sowie Vorlagen gelöscht und bearbeitet werden.

{@img img1.png}

### Dokumentvorlagen über den Archivbaum ändern

Vertragsklausel-Vorlagen können unter <span
style='font-weight:bold;font-style:italic'>// Administration // Business Solutions Custom // contract // Configuration // Clause templates</span> definiert werden.

{@img img3.png}

## Technische Grundlagen zu Vertragsklauseln

### Inhalte von Vertragsklauseln

Technisch gesehen besteht jede Klausel aus einem Word-Dokument mit einem entsprechenden Textabsatz.

{@img img5.png}

Jede Klausel erhält beim Anlegen eine eindeutige ID und es kann hinterlegt werden, für welche Vertragskategorie und für welchen Vertragstyp die Klausel verwendet werden kann. Eine Mehrfachauswahl ist mit einem Pilgrow-Zeichen getrennt möglich. Falls die Klausel für alle Vertragskategorien oder für alle Vertragstypen verwendet werden kann, wird dies mit <span
style='font-weight:bold;font-style:italic'>ALL</span> gekennzeichnet.

{@img img7.png}

Vertragsklauseln besitzen den Solution-Typ <span
style='font-weight:bold;font-style:italic'>CONTRACT_CLAUSE</span> und für die Erzeugung der Klausel-ID kann ein Generator hinterlegt werden.

{@img img9.png}

### Übernahme von Klauseln in das Vertragsdokument

Bei der Übernahme einer Klausel in ein Vertragsdokument wird der komplette Text des Word-Dokuments der Klausel in ein Inhaltssteuerelement des Vertragsdokuments eingefügt. Die Verwendung von Inhaltssteuerelementen ermöglicht es, Vertragsklauseln bei Bedarf nachträglich zu aktualisieren. Die Position innerhalb des Dokuments ist hierbei egal, das Inhaltssteuerelement kann beliebig verschoben werden.

{@img img11.png}

Referenziert werden Vertragsklauseln über die Klausel-ID, die im Tag des entsprechenden Steuerelements zu finden ist.

{@img img13.png}

Ein typisches Beispiel-Tag:
<span
style='font-weight:bold'>sol.common.DocumentPart.CLAUSE_ID=CL0001</span>

<span class="tag_important">Werden Klauseln in einem Dokument hinzugefügt, befinden sich diese immer am Ende des Dokuments auf einer neuen Seite.</span>

### Ablagepfad

In ELO Contract lassen sich Vertragsklauseln verwalten und in Word-Dokumente einfügen. Im Standard werden Vertragsklauseln unter <span
style='font-weight:bold'>// Vertragsmanagement // Vertragsklauseln</span> abgelegt.

{@img img15.png}

Der Ablagepfad kann in der Konfiguration unter <span
style='font-weight:bold'>// Verträge // Ablagepfade</span> angepasst werden.

{@img img17.png}
